/***************************************************************************
*
* Copyright 2012 Valeo
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#include <sstream>

#include "RendererList.h"
#include "Surface.h"
#include "Scene.h"
#include "SurfaceSetKeyboardFocusCommand.h"
#include "ICommandExecutor.h"
#include "InputManager.h"

ExecutionResult SurfaceSetKeyboardFocusCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());

    ExecutionResult result = ExecutionFailed;

    Surface* surface = scene.getSurface(m_surfId);

    if (surface)
    {
        SeatList surfAccpSeats = surface->getAcceptedSeats();
        SeatList::iterator seat_it;
        RendererList* rList;
        RendererListConstIterator it;

        result = ExecutionSuccess;
        rList = executor->getRendererList();
        for (seat_it = surfAccpSeats.begin();
                (seat_it != surfAccpSeats.end()) && (result == ExecutionSuccess); seat_it++)
        {
            for (it = rList->begin(); (it != rList->end()) && (result == ExecutionSuccess); it++)
            {
                InputManager* pInputManager = (*it)->getInputManager((char*)(*seat_it)->c_str());
                if (NULL != pInputManager)
                {
                    result = pInputManager->setKeyboardFocusOn(m_surfId) ? ExecutionSuccess : ExecutionFailed;
                }
                else
                {
                    std::string seatName((*seat_it)->c_str());
                    result = ExecutionFailed;
                    LOG_ERROR("SurfaceSetKeyboardFocusCommand", "obtained NULL input manager for seat :" << seatName);
                }
            }
        }
    }

    return result;
}

const std::string SurfaceSetKeyboardFocusCommand::getString()
{
    std::stringstream description;

    description << "SurfaceSetKeyboardFocusCommand("
                << "m_surfId=" << m_surfId << "(0x" << std::hex << m_surfId << ")" << std::dec
                << ")";
    return description.str();
}



